
#include "base/Container/Vector.h"
#include <string>
#include <map>

class cSimpleDOM
{
public:

    std::string _name;
    std::map<std::string, std::string> _attributes;
    PE::vector<cSimpleDOM> _children;

    void clear();
    bool hasAttribute(const std::string& attribute) const;
    std::string getAttribute(const std::string& attribute) const;

    int32_t attributeAsLong(const std::string& attribute) const;
    int32_t attributeAsLongWithDefault(const std::string& attribute, int32_t defaultValue) const;
    float attributeAsFloat(const std::string& attribute) const;
    float attributeAsFloatWithDefault(const std::string& attribute, float defaultValue) const;
    bool attributeAsBool(const std::string& attribute) const;
    bool attributeAsBoolWithDefault(const std::string& attribute, bool defaultValue) const;

    void getAllAttributes(PE::vector<std::string>& result) const;

    int32_t firstChildWithName(const std::string& name) const;
    cSimpleDOM& refFirstChildWithName(const std::string& name);
    const cSimpleDOM& refFirstChildWithName(const std::string& name) const;
};
