
#include "base/types/Header.h"
#include "sampleShared/Sliding.h"

enum class eSide
{
    CENTRE,
    LEFT,
    RIGHT
};

inline eSide SideOfLine(const int32_t *line, int32_t x, int32_t y)
{
    int32_t axisX=line[2]-line[0];
    int32_t axisY=line[3]-line[1];
    x-=line[0];
    y-=line[1];
    int32_t lhs,rhs;
    lhs=x*axisY;
    rhs=y*axisX;
    if(lhs==rhs)
        return eSide::CENTRE;
    if(lhs<rhs)
        return eSide::LEFT;
    return eSide::RIGHT;    
}

inline void PushToLeftOfLine(const int32_t *line, int32_t &x, int32_t &y)
{
    int32_t axisX=line[2]-line[0];
    int32_t axisY=line[3]-line[1];
    int32_t absolute_x,absolute_y;

    absolute_x=axisX;
    if(absolute_x<0)
        absolute_x=-axisX;
    absolute_y=axisY;
    if(absolute_y<0)
        absolute_y=-axisY;
    
    // force rounding in axis with smaller component
    if(absolute_y>absolute_x)
    {
        if(axisY>0)
            x--;
        else
            x++;
    }
    else
    {
        if(axisX<0)
            y--;
        else
            y++;
    }
}

void SlideAgainst(const int32_t* collidingLine, int32_t currentx, int32_t currenty, int32_t& dx, int32_t& dy)
{
    float dotproduct = static_cast<float>(dx * (collidingLine[2] - collidingLine[0]) + dy * (collidingLine[3] - collidingLine[1]));
    float ratio = dotproduct;
    int32_t axisX=collidingLine[2]-collidingLine[0];
    int32_t axisY=collidingLine[3]-collidingLine[1];
    float axisLengthSquared = static_cast<float>(axisX * axisX + axisY * axisY);
    ratio/=axisLengthSquared;
    dx = static_cast<int32_t>(static_cast<float>(axisX) * ratio);
    dy = static_cast<int32_t>(static_cast<float>(axisY) * ratio);
    int32_t targetx,targety;
    targetx=currentx+dx;
    targety=currenty+dy;
    if(SideOfLine(collidingLine,targetx,targety)==eSide::RIGHT)
    {
        PushToLeftOfLine(collidingLine,targetx,targety);
        dx=targetx-currentx;
        dy=targety-currenty;
    }
}

void
SlideAgainst(const int32_t* collidingLine, int32_t currentX, int32_t currentY, double& targetX, double& targetY)
{
	double axisX = static_cast<double>(collidingLine[2]) - collidingLine[0];
	double axisY = static_cast<double>(collidingLine[3]) - collidingLine[1];
	double offsetX = targetX - collidingLine[0];
	double offsetY = targetY - collidingLine[1];
	double axisLengthSquared = axisX * axisX + axisY * axisY;

	double dotProduct = offsetX * axisX + offsetY * axisY;
	double projectionRatio = dotProduct / axisLengthSquared;
	double projectedX = collidingLine[0] + (axisX * projectionRatio);
	double projectedY = collidingLine[1] + (axisY * projectionRatio);

	int32_t targetX_Rounded = static_cast<int32_t>(projectedX);
	int32_t targetY_Rounded = static_cast<int32_t>(projectedY);
	if(SideOfLine(collidingLine, targetX_Rounded, targetY_Rounded) == eSide::RIGHT)
	{
		int32_t pushedTargetX = targetX_Rounded;
		int32_t pushedTargetY = targetY_Rounded;
		PushToLeftOfLine(collidingLine, pushedTargetX, pushedTargetY);
		projectedX += pushedTargetX - targetX_Rounded;
		projectedY += pushedTargetY - targetY_Rounded;
	}

	targetX = projectedX;
	targetY = projectedY;
}
