#include "sampleShared/ZoomExtents.h"
#include "base/Container/Vector.h"
#include "externalAPI/i_pathengine.h"
#include "base/types/Header.h"

using PE::vector;

static void
GetAllVertPoints(const iMesh& mesh, vector<float>& result)
{
    for(int32_t f = 0; f != mesh.getNumberOf3DFaces(); ++f)
    {
        for(int32_t v = 0; v != 3; ++v)
        {
            int32_t x, y;
            float z;
            mesh.get3DFaceVertex(f, v, x, y, z);
            result.push_back(static_cast<float>(x));
            result.push_back(static_cast<float>(y));
            result.push_back(z);
        }
    }
}
static void
GetAllVertPoints(const iFaceVertexMesh& mesh, vector<float>& result)
{
    for(int32_t v = 0; v != mesh.vertices(); ++v)
    {
        result.push_back(static_cast<float>(mesh.vertexX(v)));
        result.push_back(static_cast<float>(mesh.vertexY(v)));
        result.push_back(mesh.vertexZ(v));
    }
}
void
ZoomExtents(iTestBed& testBed, const iMesh& mesh)
{
    vector<float> pointData;
    GetAllVertPoints(mesh, pointData);
    if(!pointData.empty())
        testBed.zoomExtents(&pointData.front(), SizeU(pointData));
}
void ZoomExtents(iTestBed& testBed, iFaceVertexMesh& mesh)
{
    vector<float> pointData;
    GetAllVertPoints(mesh, pointData);
    if(!pointData.empty())
        testBed.zoomExtents(&pointData.front(), SizeU(pointData));
}
